//WrappingTextView class

//Extends BTextView functionality somewhat.  Automates setting up the TextRect and updating it during resizing
//so that re-wrapping is live.  Also provides a StoreChanges hook function that is called when the WrappingTextView
//loses focus or is removed from the window or destroyed.  This is useful if the view is of an object that can
//exist without the view, so that this more persistent object can be kept up-to-date when the text is modified,
//without having to update the other object every time a character is entered.


#ifndef _SGB_WRAPPING_TEXT_VIEW_H_
#define _SGB_WRAPPING_TEXT_VIEW_H_


#include <TextView.h>


class WrappingTextView : public BTextView
{
	public:
		WrappingTextView(BRect a_frame,const char* a_name,int32 a_resize_mode,int32 a_flags);
		virtual ~WrappingTextView();

		//BTextView overrides
		virtual void DetachedFromWindow();
		virtual void FrameResized(float a_width, float a_height);
		virtual void MakeFocus(bool a_focused);
		void SetText(const char *text, int32 length, const text_run_array *runs = NULL);
		void SetText(const char *text, const text_run_array *runs = NULL);
		void SetText(BFile *file, int32 offset, int32 length, const text_run_array *runs = NULL);
		virtual void StoreChange();
		virtual void Modified();
		bool HasBeenModified();
		void ResetTextRect();

	protected:
		virtual void InsertText(const char *a_text, int32 a_length, int32 a_offset, const text_run_array *a_runs);

	private:
		bool m_modified;
		bool m_modified_disabled;
};


#endif
